# 第六章 中国开源教育现状

开源教育是一种全民教育，旨在让每个数字时代的公民了解开源的理念与文化，学习数字化协作的能力，共享开源开放的成果。开源教育涵盖开源文化教育、开源意识教育、开源技能教育三方面[]。开源文化教育内容主要包括开源社区的形成机理和运转机制及其得以持续生存和发展的机制机理等,同时还包括开源历史、开源共识及开源社区的治理规则等。开源意识教育包括创新意识和开放透明的协作共享意识教育。创新意识表现在可以在开源技术迭代的基础上,敏锐感知新兴技术的需求并进行快速创造。协作共享意识表现在在适应全球分布式开发的趋势。开源技能体现为开发者传统的编程能力,开发者对开源技术和工具的使用能力以及分布式环境下的协调协作能力。

## 6.1 开源教育正加速融入并贯穿教育全阶段

### 6.1.1 高中小学开源教育

在人才培养的高中小学阶段，开源文化与技术逐渐渗入庞大的教学体系机制。尽管中小学高考体系面临缺少开源文化模块的导向现实，然而开源借助低成本、低技术门槛、便于学习和应用等优势吸引了各地高中小学以开源作为开展素质教育、创客教育的工具，培养学生科学精神和创造力。众多开源组织、开源在线教育平台开展了师资培训及学生创客活动，进行开源启蒙教育。

### 6.1.2 开源高等教育

高等院校开源教育从学生、教师自发开源教育行为转变为院校行为。在高校推进开源教育，建立产学研一体化开源创新人才培养体系，对我国培养适应产业需要软件人才、建立可持续发展开源生态、提升软件科技源头创新和软件技术供给能力、实现向创新链高端跃升具有重要意义。例如，早期国防科技大学毛新军教授团队基于社交化编程思想和群智共创理念，设计了群体化学习平台原型系统（LernerHub）。其主体内容包括：群体化学习内容共创、群体化学习主题研讨、群体化学习问题解决、群体化教学过程外包四大部分。平台采用类似于知乎的Topic、comments结构，可以方便地对所发布的学习主题进行研讨和评价，用以支撑开源活动和进行开源教育。

随着开源教育的逐步深入，开源教育逐渐转变为院校行为。2020年6月5日，教育部和工信部联合发布了《特色化示范性软件学院建设指南》，其中指出要在上述五个重点领域培育建设一批特色化软件学院，加快人才培养，缓解我国经济社会数字化转型对数字人才的迫切需求。对接教育部“计算机领域本科教育教学改革试点工作计划（101计划）”，

目前国内一些高校已经在积极探索我国开源创新人才的培养路径，推动我国开源软件生态建设，提升软件人才与关键软件技术创新和供给能力。众多高等院校加大开源基础设施投入力度，组织开源相关讲座、活动。在高校中课程教师授课中涉及开源的内容占比以及学科深度逐渐增加。
	
### 6.1.3 职业教育与终身教育

开源职业教育跟随行业需求飞速发展。随着互联网技术的发展，开源相关培训、网络课程规模增多。一种基于网络的大规模开放在线课程MOOC学习模式出现，大量优质的课程资源免费共享，吸引了来自全球学习者注册学习，其中典型的代表是edX、Couresra、Udacity等MOOC平台等。同时，在这一阶段，大量知名开源项目为了推动相应技术的大规模应用，也开始组建专门的技术培训学院，发布相应培训认证课程，围绕开源项目推动具体的教育，如RedHat推出了体系化的Linux认证课程等。GitHub、Trustie、开源中国、CSDN等开源社区上的优质项目也为学习者提供了向全球顶级开发者学习实践的通道。

## 6.2 开源教育平台和开源协作模式发展迅速

### 6.2.1 基于开发工具和知识社区的开源教育平台

基于开发工具的开源教育平台支持大规模开源开发者分享开源技术、传播开源理念、推广开源项目。基于开发工具的平台典型代表包括 Github.com、SourceForge.net、Trustie.net、Gitee.com、learnerhub.net等。其中，GitHub平台是于2008年4月10日正式上线，除了Git代码仓库托管及基本的Web管理界面以外，还提供了订阅、讨论组、文本渲染、在线文件编辑器、协作图谱（报表）、代码片段分享（Gist）等功能。Gitee（码云）是开源中国于2013年推出的基于Git的代码托管和协作开发平台，提供本土化的代码托管服务。同时Gitee也提供了开源软件的发布和沟通社区，供开发者在其中进行技术交流与沟通。

基于知识社区的开源教学平台提供了软件工程服务、讨论区、资源库等，形成了活跃的互动在线学习模式。平台典型代表包括Stackoverflow.com、CSDN.net、learnerhub.net等。其中，Stack Overflow由Jeff Atwood和Joel Spolsky这两个非常著名的Blogger在 2008年创建，旨在提供一个与程序相关的IT技术问答网站。中国专业IT社区CSDN (Chinese Software Developer Network) 创立于1999年，致力于为中国软件开发者提供知识传播、在线学习、职业发展等全生命周期服务。

### 6.2.2 基于开放实践和开源竞赛的开源教育平台

基于开放实践和开源竞赛的开源教育平台支持大规模开源开发者参与开源项目实训，该类平台以实践需要为导向，形成了产教一体化的在线学习模式。例如，EduCoder是一个由国内知名高校、产业联盟和大型企业共同发起的新型信息技术工程教育平台。基于国家科技部重点项目成果——Trustie群体化方法与机理，EduCoder支持程序设计、软件工程、数据库、操作系统、云计算、大数据、人工智能、深度学习等全品类计算机专业方向的教学、实验、实训和科研活动，同时也支持老师和开发者按需自主创建实践课程，为各类高校和社会各界提供高可扩展和高可定制的信息技术工程教学资源、计算资源和教学服务。百度AI Studio是针对AI学习者的在线一体化学习与实训社区. 本平台集合了AI教程, 深度学习样例工程, 各领域的经典数据集, 云端的超强运算及存储资源, 以及比赛平台和社区。从而解决学习者在AI学习过程中的一系列难题, 例如教程水平不一, 教程和样例代码难以衔接, 高质量的数据集不易获得, 以及本地难以使用大体量数据集进行模型训练。
 
竞赛类学习平台主要采用在线编程竞赛的形式促进学习者进行程序设计语言学习、算法设计、编程应用等。例如，Topcoder平台（topcoder.com）每个月都有2-3次在线编程比赛，参赛者可根据自己的爱好选用Java、C++、C#、VB或 Python进行编程。Kaggle平台（kaggle.com）为学习者提供了举办机器学习竞赛、托管数据库、编写和分享代码的环境，近些年吸引了大量学习者的关注。EduCoder将全栈化智能实践技术引入在线季赛，有效支持在线实战化的全流程竞赛和活动。

自2018年以来，全国高校绿色计算大赛已成功举办四届。其中，2020年第三届绿色计算大赛累计吸引了来自全国570所高校、12000余名师生报名参赛，整个大赛围绕能力竞技和开源创新设置了任务挑战、代码标注、开源创新和实践教学四个赛道，围绕来自产业界的顶级开源项目和真实应用需求设置赛题。整个大赛期间，创新程序部署评测超过10万次，产生高质量标注达63000余条，实践教学案例超过19000个，使用超过15万人次，开源项目创新贡献得到华为技术专家的高度认可。

## 6.3 探索校企结合的开源教育协同模式

虽然中国开源教育模式众多，但开源人才与市场的需求仍然有着较大的差距。在国外众多知名高校已经形成了科研、教材、案例、开源项目、企业应用等为一体的开源教育体系，在企业中前沿科研成果以开源项目发布，学校围绕前沿技术编写教材和教学案例，依托开源项目开展实践教学，培养的人才对接企业需求。我国政府和众多开源企业一直在摸索适合我国开源教育的道路，以企业为主导的“联盟”模式、政府联手的“1+1+1工程”、以校园为基础的“浙江模式”和综合推进的“广州经验”，都为开源教育奠定了基础，提供了宝贵的经验，然而尚难以满足行业庞大的需求。

### 6.3.1 开源教育由多主体承担

**社区开源教育**

以开源社区/开源基金会为依托，通过自觉不自觉的方式推动的教育活动。Linux基金会、OpenStack基金会等为推广相应开源社区和开源技术，常态化的组织相应的开源治理交流、开源技术讨论、技术能力培训认证等。例如，开源人才培育中心红帽学院提供多样化的开源课程内容、灵活的实训教学环境、实际任务操作型认证考试和全球通用的标准化资料。

**企业开源教育**

大量企业构建了专门的开源团队持续投入开源项目的研发，同时也围绕开源技术组织大规模的教育培训、能力认证以及宣传推广等活动。例如，中标麒麟教育学院（由中标软件有限公司受国家Linux技术培训与推广中心的委托信息技术人才培训基地）是目前中国最大的也是唯一的国产Linux操作系统厂商培训机构。它在各高校中建设了大数据实验室、可信计算实验室、安全攻防实验室和安全测评实验室，与高校共同增设专业方向，引入中标麒麟教育学院的优秀教学资源，实施“课堂教学+实战”相结合的教学模式，实现学历教育与职业教育的双重培养。

**高校开源教育**

欧洲和美国许多大学鼓励学生参与开源，我国高校也围绕将开源技术融入到人才培养尤其是实践教学环节开展了有益的探索。例如2005年，开源高校推进联盟（LUPA）在杭州成立，对我国开源人才培养起到了积极的推进作用。Trustie平台是国防科技大学、北京大学、北京航空航天大学等单位合作构建的面向群体化开发的协同生产环境，提供了软件工程大数据服务、讨论区、资源库等，为学习者更好地进行开源学习提供了支持。

**科研院所开源教育**

众多科研院所积极推进开源教育。例如开源供应链点亮计划是由中科院软件所和openEuler社共同举办的一项面向高校学生的暑期活动，旨在鼓励在校学生积极参与开源软件的开发和维护中，促进国内优秀开源软件社区的蓬勃发展。

### 6.3.2 协同教育模式成为开源教育发展趋势
	
**政府引导**

2020年6月20，教育部办公厅、工业和信息化部办公厅联合印发《特色化示范性软件学院建设指南（试行）》提出，以特色化软件人才培养为目标，以深化产教融合为途径，以改革创新为驱动，以特色发展为重点，深化软件人才培养模式改革，大力开展关键核心软件技术攻关，促进软件生态体系建设，充分发挥软件人才培养对产业发展的支撑引领作用，推动我国软件产业实现由大到强的历史跨越。

**高校、企业、社区、科研院所多方参与**

随着开源教育从传统理论课程向与实践结合的综合培养模式转变，高校、企业和开源社区、科研院所四方协作等协同创新模式不断被探索，共同培养开源人才的方式逐渐演变为未来发展趋势。一些企业与高校联动，形成校企联合建设实训基地。企业可为高校提供专业级实训平台，提供课程实践案例，提供业内导师，以及以横向课题的形式形成科研成果等，高校则不断为企业输送具有实践能力的专业人才。例如极狐(GitLab)免费向X-lab成员中的华东师范大学数据科学与工程学院师生提供极狐GitLab旗舰版使用许可。并且，X-lab实验室将极狐在开源文化，开源社区运营管理，DevOps等领域的通识知识纳入教材编写与人才培养计划。同时，X-lab利用极狐技术平台，利用开源社区资源，基于极狐GitLab平台研发 “校园版”DevOps。

**平台助力**

2021年成立的CCF作为中国计算机及相关领域具有广泛影响的学术团体，重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，通过培育原始开源创新项目，协同科教资源、产业资源和社会资源等探索产、教、研联动的开源创新模式，推动探索学术共同体主导的开源发展新途径，助力我国开源生态建设的发展。OSTech、华为、Linux基金会亚太区、Linux基金会开源软件学园、南方科技大学等高校开源俱乐部及企业社区联合支持而成立了高校开源社区联合体——开源高校联盟，它提供社区运营、技术、课程/认证、导师以及多方面资源和资金服务。开源高校联盟面向全球高校，包括学生、教师、研究院等成分的开发者，宗旨是连接国际一流的开源基金会、企业和院校，融合多方开源技术和经验，汇聚为集开源知识与文化、技术培训与认证、职业成长、实习与就创业的高校开源平台；致力于开源人才的培养、开源技术与文化在全球高校的推广，促进全球高校青年基于开源文化与技术的交流学习。

## 6.4 制约开源教育快速发展的瓶颈

高校开源人才培养力度与开源生态蓬勃发展之间存在矛盾和鸿沟。尽管企业、科研院所、社区等多主体开展开源教育，培养开源人才，然而，高等院校仍处于人才培养机制的核心地位，其对开源人才的培养规模体量尚小，难以支撑开源生态蓬勃发展的需要。虽然高等院校的信息类、计算机类、软件类专业教育对开源均有所涉及，但开源更多被视为工具，以开源文化、意识和相关技能为核心的教育力度不足。优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定尚待完善，以开源教育为核心的内容尚未被设置为普遍性的必修课，将其纳入学分的高校数量有限。

多主体开源教育协同机制及系统性架构发展仍在初级阶段，可持续运营模式尚待探索。然而，无论是政府、产业界还是学界已就建立产学研一体化开源创新人才培养体系以解决矛盾达成共识。教育部提出“计算机领域本科教育教学改革试点工作计划（101计划）”和“特色化示范性软件学院建设计划”。产学研各界正积极建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。

## 6.5 开源教育发展建议

全国人大代表、中国科学院院士、南京大学校长吕建针对开源教育发展提出三点建议。

第一，推动基于优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才，支撑国产开源软件形成可持续发展生态。前沿信息技术如云计算、大数据、人工智能、区块链等均以开源模式快速创新，高校相关课程体系要积极吸纳开源成果，推动基于开源的高校软件教育。一是鼓励高校和企业联合，围绕我国开源成果开发建设课程教材和实践能力教学体系，开设相应课程，通过必修课、学分制等推进课程普及。二是设计相应的激励政策和交流通道，鼓励企业开源人才进入高校课堂，建立良好的开源师资队伍。三是推动校企联合开展产业开源生态链实习，引导学生进入国产开源软件生态，为形成可持续生态培养后备力量。建议由教育部牵头，会同工信部等国家部委，以101计划和特色化示范性软件学院建设为基础，推动基于开源的教育落实到相应方案和规划中。

第二，加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果。高校是科技创新的重要源头。我国高校亟需加强面向开源的软件教育。一是在软件工程等相关课程内容设计上，主动融入开源文化、开源规律和开源模式的教学内容，培养学生的开源意识和开源技能。二是在高校学科建设评价机制方面，将成果开源情况纳入考核指标，鼓励高校师生积极参与开源社区贡献，鼓励高校形成原创性开源成果。建议由教育部牵头，会同科技部等国家部委，推动面向开源的软件教育课程内容改革以及教学科研评价机制设计。

第三，以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。开源教育应拓展到人才培养成长的各个阶段，需要相应平台和政策环境的支持。一是以各类教学服务平台为基础，以开源实践创新为抓手，打造涵盖学习实践和创新创业的云原生产教融合开源实践平台和开放共享学习创业社区；二是以学生为中心，以融合平台为依托，联合高校、企业、投融资机构等建立起支持学生从开源实践到创新创业的机制和途径。建议由教育部联合工信部、国家发改委、中国科协等共同设计行动方案。

